<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App;
use DateTime;


// namespace App\Exceptions;

use Exception;

class pembayaranController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request){

    	$listPembayarans = DB::table('pembayarans')
    					->select('id_bayar','customers.customer_id','nama','alamat','telepon','tgl_pasang','speed','nominal_tagihan','tgl_bayar')
    					->join('customers','pembayarans.customer_id','=','customers.customer_id')
    					->orderBy('tgl_bayar','desc')
    					->paginate(50);

    	return view('listPembayaran', ['listPembayarans'=>$listPembayarans]);

    }

    public function getListPembayaran(Request $request){

    	$listPembayaran = DB::table('pembayarans')
    					->select('id_bayar','customers.customer_id','nama','alamat','telepon','tgl_pasang','speed','nominal_tagihan','tgl_bayar')
    					->join('customers','pembayarans.customer_id','=','customers.customer_id')
    					->orderBy('tgl_bayar','desc')
    					->get();

    	printf($listPembayaran);

    }

}
