<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\dashboardController;

use App\Http\Controllers\pembayaranController;
use App\Http\Controllers\PDFController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('/dashboard');
});

Route::get('/dashboard', [dashboardController::class, 'index'])->name('dashboard');
Route::get('/listPembayaran', [pembayaranController::class, 'index'])->name('pembayaran');


Route::get('/register', [dashboardController::class, 'registerbro']);

Route::get('/openTambahPelanggan', [dashboardController::class, 'open_tambah_pelanggan'])->name('otp');
Route::get('/funcTambahPelanggan', [dashboardController::class, 'func_tambah_pelanggan']);
Route::get('/funcEditPelanggan', [dashboardController::class, 'func_edit_pelanggan']);
Route::get('/funcHapusPelanggan', [dashboardController::class, 'func_hapus_pelanggan']);

Route::get('/getCustomer/{tahun}/{page}/{search}', [dashboardController::class, 'getCustomer']);
Route::get('/getListPembayaran', [pembayaranController::class, 'getListPembayaran']);

Route::post('/postbayar', [dashboardController::class, 'postBayar']);
Route::post('/posttidakbayar', [dashboardController::class, 'postTidakBayar']);

Route::get('/pengisi_pelanggan', [dashboardController::class, 'pengisi_pelanggan']);

Route::get('/print_invoice', [dashboardController::class, 'print_invoice']);


Route::get('/fpdf', function () {

   $pdf = App::make('dompdf.wrapper');
	$pdf->loadHTML('<h1>Test</h1>');
	return $pdf->stream();

});
require __DIR__.'/auth.php';
